USE [NWIC_PanelMgmt]
GO

/****** Object:  Table [App].[AllCDWPatients]    Script Date: 3/23/2017 9:13:41 AM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

SET ANSI_PADDING ON
GO

CREATE TABLE [App].[AllCDWPatients](
	[Sta3n] [smallint] NOT NULL,
	[PatientIEN] [varchar](50) NULL,
	[PatientSSN] [varchar](50) NULL,
	[PatientSID] [int] NOT NULL,
	[PatientICN] [varchar](55) NULL,
	[PatientName] [varchar](100) NULL,
	[DateOfBirth] [date] NULL,
	[LastFour] [varchar](4) NULL,
	[CPRSKey] [varchar](10) NULL,
	[PrimaryProviderSID] [int] NULL,
	[PrimaryProviderName] [varchar](100) NULL,
	[PCPTeamSID] [int] NULL,
	[PCPTeam] [varchar](50) NULL,
	[Sta6a] [varchar](50) NULL,
	[Clinic] [varchar](50) NULL,
	[HomeSta3n] [smallint] NULL,
	[Deceased] [bit] NULL,
	[DateOfDeath] [date] NULL,
	[TestPatientFlag] [bit] NULL,
	[NOKAddressSID] [int] NULL
) ON [DefFG]

GO

Create Clustered Index AllCDWPatients_Sta3n_PatientSSN
On App.AllCDWPatients (Sta3n, PatientSSN)
With (SORT_IN_TEMPDB = ON, DATA_COMPRESSION = PAGE)

Create nonclustered index AllCDWPatients_PatientICN on App.AllCDWPatients (PatientICN)
include (PatientSID, PatientSSN, Sta3n, Deceased, DateOfDeath)
with (SORT_IN_TEMPDB = ON, DATA_COMPRESSION = PAGE)

Create nonclustered index AllCDWPatients_PatientSID on App.AllCDWPatients (PatientSID)
include (PatientICN, Deceased, DateOfDeath)
with (SORT_IN_TEMPDB = ON, DATA_COMPRESSION = PAGE)

Create nonclustered index AllCDWPatients_PatientName on App.AllCDWPatients (PatientName)
include (PatientICN, PatientSID, PatientSSN, Sta3n, Deceased, DateOfDeath)
with (SORT_IN_TEMPDB = ON, DATA_COMPRESSION = PAGE)

Create nonclustered index AllCDWPatients_CPRSKey on App.AllCDWPatients (CPRSKey)
include (PatientICN, PatientSID, PatientSSN, Sta3n, Deceased, DateOfDeath)
with (SORT_IN_TEMPDB = ON, DATA_COMPRESSION = PAGE)

Create nonclustered index AllCDWPatients_PrimaryProviderSID on App.AllCDWPatients (PrimaryProviderSID)
include (PrimaryProviderName, PatientICN, PatientSID)
with (SORT_IN_TEMPDB = ON, DATA_COMPRESSION = PAGE)

SET ANSI_PADDING ON
GO


